model Ex23_4

parameter Real P_TV(unit="W")=200"Required power for TV";
parameter Real P2(unit="W")=2000"Required power for Air conditioner";
parameter Real P1(unit="W")=60*10"Required power for bulbs";
parameter Real Vp(unit="V")=2400;
parameter Real Vs(unit="V")=240;
parameter Real V(unit="V")=120;
parameter Real V2(unit="V")=240;

Real PT(unit="W")"Total Power";
Real PT1(unit="W")"Total Power";
Real Ip(unit="A")"Current";
Real R(unit="ohm")"Resistance";
Real I1(unit="A")"Current";
Real I2(unit="A")"Current";
Real VL(unit="V")"Voltage";
Real Pp(unit="W")"Power";
Real a;

equation

PT=P_TV+P1+P2;
PT=Vp*Ip;
R=Vp/Ip;
P1=V*I1;
P2=V2*I2;
VL=sqrt(3)*Vp;
Pp=PT;
PT1=3*Pp;
a=Vp/Vs;

// Values are not matching with the textbook due to round off

end Ex23_4;