model Ex5_31


parameter Real R1(unit="ohm")=10"resistance";
parameter Real R2(unit="ohm")=40"resistance";
parameter Real R3(unit="ohm")=50"resistance";
parameter Real E1(unit="V")=240"Voltage";
parameter Real E2(unit="V")=60"Voltage";

Real I(unit="A")"Current";
Real V1(unit="V")"Voltage";
Real V2(unit="V")"Voltage";
Real V3(unit="V")"Voltage";
Real Vb(unit="V")"Voltage";
Real Vc(unit="V")"Voltage";
Real Vad(unit="V")"Voltage";
Real RT(unit="ohm")"Total resistance";


equation

RT=R1+R2+R3;
I=(E1-E2)/RT;
V1=I*R1;
V2=I*R2;
V3=I*R3;
Vc=-V2;
Vb=-V2-V3;
Vad=E1-V1;

end Ex5_31;