model Ex5_7

parameter Real R1(unit="kohm")=1"resistance";
parameter Real R2(unit="kohm")=3"resistance";
parameter Real R3(unit="kohm")=2"resistance";
parameter Real E(unit="V")=36"Voltage";

Real RT(unit="kohm")"Total resistance";
Real Is(unit="mA")"Current flow in circuit";
Real V1(unit="V")"Voltage across first element";
Real V2(unit="V")"Voltage across second element";
Real V3(unit="V")"Voltage across third element";
Real PE(unit="mW")"power supplied by battery";
Real P1(unit="mW")"power dissipated by first resistor";
Real P2(unit="mW")"power dissipated by first resistor";
Real P3(unit="mW")"power dissipated by first resistor";


equation

RT=R1+R2+R3;
Is=E/RT;
V1=Is*R1;
V2=Is*R2;
V3=Is*R3;
PE=E*Is;
P1=V1*Is;
P2=V2*Is;
P3=V3*Is;

end Ex5_7;