model Ex7_11

parameter Real R1(unit="ohm")=10"resistance";
parameter Real R2(unit="ohm")=4"resistance";
parameter Real R3(unit="ohm")=5"resistance";
parameter Real E1(unit="V")=20"Source Voltage";
parameter Real E2(unit="V")=5"Source Voltage";
parameter Real E3(unit="V")=8"Source Voltage";


Real Is3(unit="A")"source Current";
Real I1(unit="A")"Current";
Real I2(unit="A")"Current";
Real Va(unit="V")"Voltage";
Real Vc(unit="V")"Voltage";
Real V3(unit="V")"Voltage";
Real Vb(unit="V")"Voltage";
Real Vac(unit="V")"Voltage";
Real Vbc(unit="V")"Voltage";
Real V1(unit="V")"Voltage";
Real V2(unit="V")"Voltage";


equation

Va=E1;
Vc=E3;
E1-E2-V3=0;
Vb=V3;
Vac=Va-Vc;
Vbc=Vb-Vc;
I2=V2/R2;
V2=Vbc;
I1=V1/R1;
Is3=-I1-I2;
V1=Vac;

end Ex7_11;