model Ex7_12

parameter Real E(unit="V")=72"Source Voltage";
parameter Real E3(unit="V")=8"Voltage";
parameter Real Is(unit="mA")=50"source Current";
parameter Real IL1(unit="mA")=20"Load Current";
parameter Real IL2(unit="mA")=10"Load Current";
parameter Real VL1(unit="V")=60"Voltage";
parameter Real VL2(unit="V")=20"Voltage";
parameter Real VR2(unit="V")=20"Voltage";
parameter Real VR3(unit="V")=12"Voltage";

Real R1(unit="kohm")"resistance";
Real R2(unit="kohm")"resistance";
Real R3(unit="kohm")"resistance";
Real VR1(unit="V")"Voltage";
Real IR3(unit="mA")"Current";
Real IR1(unit="mA")"Current";
Real IR2(unit="mA")"Current";
Real PR1(unit="W")"Power";
Real PR2(unit="W")"Power";
Real PR3(unit="W")"Power";

equation

IR3=Is;
IR1=Is-IL1;
IR1-IR2-IL2=0;

R1=VR1/IR1;
R2=VR2/IR2;
R3=VR3/IR3;

VR1=VL1-VL2;

PR1=((IR1)^2)*R1/1000;
PR2=((IR2)^2)*R2/1000;
PR3=((IR3)^2)*R3/1000;

end Ex7_12;