model Ex7_4

parameter Real R1(unit="ohm")=9"resistance";
parameter Real R2(unit="ohm")=6"resistance";
parameter Real R3(unit="ohm")=4"resistance";
parameter Real R4(unit="ohm")=6"resistance";
parameter Real R5(unit="ohm")=3"resistance";
parameter Real R6(unit="ohm")=3"resistance";
parameter Real E(unit="V")=16.8"Source Voltage";

Real RA(unit="ohm")"resistance";
Real RB(unit="ohm")"resistance";
Real RC(unit="ohm")"resistance";
Real R_BC(unit="ohm")"resistance";
Real RT(unit="ohm")"resistance";
Real Is(unit="A")"source Current";
Real IA(unit="A")"Current";
Real I1(unit="A")"Current";
Real I2(unit="A")"Current";
Real IB(unit="A")"Current";
Real IC(unit="A")"Current";
Real VA(unit="V")"Voltage";
Real VB(unit="V")"Voltage";
Real VC(unit="V")"Voltage";

equation

RA=R1*R2/(R1+R2);
RB=R3+R4*R5/(R4+R5);
RC=R6;
R_BC=RB*RC/(RB+RC);
RT=RA+R_BC;
Is=E/RT;
IA=Is;
IB=RC*IA/(RC+RB);
IC=IA-IB;
VA=IA*RA;
VB=IB*RB;
VC=VB;
I1=R2*IA/(R1+R2);
I2=IA-I1;


end Ex7_4;