model Ex9_1

parameter Real R1(unit="ohm")=12"Resistance";
parameter Real R2(unit="ohm")=6"Resistance";
parameter Real E(unit="V")=36"Source Voltage";
parameter Real I(unit="A")=9"Current";

Real I2_das(unit="A")"Current";
Real I2_ddas(unit="A")"Current";
Real I2(unit="A")"Current";
Real P1(unit="W")"Power";
Real P2(unit="W")"Power";
Real PT(unit="W")"Power";
Real P(unit="W")"P1+P2";

equation

I2_das=E/(R1+R2);
I2_ddas=R1*I/(R1+R2);
I2=I2_das+I2_ddas;
P1=(I2_das^2)*R2;
P2=(I2_ddas^2)*R2;
PT=(I2^2)*R2;
P=P1+P2;

end Ex9_1;