model Ex9_20

parameter Real R1(unit="ohm")=1"Resistance";
parameter Real R2(unit="ohm")=6"Resistance";
parameter Real R3(unit="ohm")=2"Resistance";
parameter Real E1(unit="V")=5"Source Voltage";
parameter Real E2(unit="V")=10"Source Voltage";

Real Req(unit="ohm")"Resistance";
Real Eeq(unit="V")"Source Voltage";
Real I1(unit="A")"Current";
Real I2(unit="A")"Current";
Real I2ohm(unit="A")"Current";
Real IT(unit="A")"Current";
Real G1(unit="S")"Conductance";
Real G2(unit="S")"Conductance";
Real GT(unit="S")"Conductance";

equation

G1=1/R1;
G2=1/R2;
GT=G1+G2;
I1=E1/R1;
I2=E2/R2;
IT=I1+I2;
Eeq=IT/GT;
Req=1/GT;
I2ohm=Eeq/(Req+R3);


end Ex9_20;