model Ex20_1

parameter Real VR1(unit="V")=0"Voltage at t1";
parameter Real VR2(unit="V")=12"Voltage at t2";
parameter Real VR3(unit="V")=6"Voltage at t3";
parameter Real VR4(unit="V")=0"Voltage at t4";
parameter Real VR5(unit="V")=-12"Voltage at t5";
parameter Real VR6(unit="V")=0"Voltage at t6";
parameter Real iR1(unit="A")=0"Current at t1";
parameter Real iR4(unit="A")=0"Current at t4";
parameter Real iR6(unit="A")=0"Current at t6";
parameter Real R(unit="ohm")=4"resistance";
parameter Real f1(unit="KHz")=1"Frequency";

Real Vm(unit="V")"Voltage";
Real Im(unit="A")"Current";
Real iR2(unit="A")"Current at t2";
Real iR3(unit="A")"Current at t3";
Real iR5(unit="A")"Current at t5";
Real PR1(unit="W")"Power at t1";
Real PR2(unit="W")"Power at t2";
Real PR3(unit="W")"Power at t3";
Real PR4(unit="W")"Power at t4";
Real PR5(unit="W")"Power at t5";
Real PR6(unit="W")"Power at t6";
Real P(unit="W")"Power";
Real WR(unit="mJ")"Power";
Real VR[1,6](each unit="V");
Real iR[1,6](each unit="A");

equation

iR2=VR2/R;
iR3=VR3/R;
iR5=VR5/R;
Vm=max(VR);
Im=max(iR);

PR1=VR1*iR1;
PR2=VR2*iR2;
PR3=VR3*iR3;
PR4=VR4*iR4;
PR5=VR5*iR5;
PR6=VR6*iR6;
P=(Vm*Im)/2;
WR=(Vm*Im)/(2*f1);
VR=[VR1,VR2,VR3,VR4,VR5,VR6];
iR=[iR1,iR2,iR3,iR4,iR5,iR6];

end Ex20_1;