model Ex20_8

parameter Real P0_hp(unit="hp")=5"Power in hp";
parameter Real nita=0.92;
parameter Real Fp=0.6;
parameter Real Fp1=1;
parameter Real R2D=Modelica.Constants.R2D;
parameter Real V(unit="V")=208"Voltage";
parameter Real D2R=Modelica.Constants.D2R;
parameter Real f(unit="Hz")=60"Frequency";
parameter Real pi=Modelica.Constants.pi;


Real P0_w(unit="W")"Power in W";
Real Pi(unit="W")"Power in W";
Real thita(unit="deg");
Real QL(unit="VAR(L)");
Real S(unit="VA");
Real XC(unit="ohm");
Real C(unit="micro farad");
Real I(unit="A")"Current";
Real thita1(unit="deg");
Real QL1(unit="VAR(L)");
Real S1(unit="VA");
Real I1(unit="A")"Current";


equation

P0_w=P0_hp*746;
Pi=P0_w/nita;
Fp=cos(thita/R2D);
QL=Pi*tan(thita*D2R);
S=sqrt(Pi^2+QL^2);
QL=V^2/XC;
C=(1/(2*pi*f*XC))*10^6;
I=S/V;
Fp1=cos(thita1/R2D);
QL1=Pi*tan(thita1*D2R);
S1=sqrt(Pi^2+QL1^2);
I1=S1/V;

end Ex20_8;