model Ex20_9

parameter Real pi=Modelica.Constants.pi;
parameter Real S(unit="kVA")=20"inductive load";
parameter Real P1(unit="kW")=10"Power";
parameter Real P2(unit="kW")=14"Power";
parameter Real E(unit="V")=1000"Voltage";
parameter Real Fp=0.95;
parameter Real R2D=Modelica.Constants.R2D;
parameter Real D2R=Modelica.Constants.D2R;
parameter Real f(unit="Hz")=60"Frequency";

Real thita(unit="deg");
Real QL(unit="kVAR(L)");
Real ST(unit="kVA");
Real IT(unit="A");
Real PT(unit="kW")"Total Power";
Real thita1(unit="deg");
Real QL_das(unit="kVAR(L)");
Real QC(unit="kVAR(L)");
Real XC(unit="ohm");
Real C(unit="micro farad");
Real ST1(unit="kVA");
Real IT1(unit="A");


equation

P2=S*cos(thita/R2D);
QL=S*sin(thita*D2R);
PT=P1+P2;
ST=sqrt(PT^2+QL^2);
IT=(ST/E)*10^3;
Fp=cos(thita1/R2D);
QL_das=PT*tan(thita1*D2R);
QC=QL-QL_das;
QC=(E^2/XC)/10^(3);
C=(1/(2*pi*f*XC))*10^6;
ST1=sqrt(PT^2+QL_das^2);
IT1=(ST1/E)*10^3;



end Ex20_9;