model Ex21_4

parameter Real pi=Modelica.Constants.pi;
parameter Real fs(unit="Hz")=2800"Frequency";
parameter Real BW(unit="Hz")=200"Band width";
parameter Real C(unit="F")=100*10^(-9)"Capacitance";
parameter Real Imax(unit="A")=200*10^(-3);

Real R(unit="ohm")"Resistance";
Real Qs;
Real E(unit="V")"Voltage";
Real L(unit="H")"inductance";
Real XL(unit="ohm");

equation

Qs=fs/BW;
XL=Qs*R;
XL=2*pi*fs*L;
L=1/(4*(pi^2)*(fs^2)*C);
E=Imax*R;

end Ex21_4;