package Ex26_7

model Ex26_7_a

parameter Real M_E(unit="V")=10/sqrt(2)"magnitude of E";
parameter Real phi_E(unit="deg")=0"angle of E";
parameter Complex Z(re(unit="ohm")=3,im(unit="ohm")=-4);
parameter Real M_R(unit="ohm")=3"magnitude of R";
parameter Real phi_R(unit="deg")=0"angle of R";
parameter Real M_XC(unit="ohm")=4"magnitude of R";
parameter Real phi_XC(unit="deg")=-90"angle of R";
parameter Real D2R=Modelica.Constants.D2R;
parameter Real Ia(unit="A")=0;
parameter Real VCa(unit="V")=12;
parameter Real VRa(unit="V")=0;
parameter Real t(unit="s")=0"time suppose time is 0 sec";

Real M_Z(unit="ohm")"Magnitude of Z";
Real phi_Z(unit="deg")"angle of Z";
Real M_I(unit="A")"Magnitude of I";
Real phi_I(unit="deg")"angle of I";
Real M_VR(unit="V")"Magnitude of VR";
Real phi_VR(unit="deg")"angle of VR";
Real M_VC(unit="V")"Magnitude of VC";
Real phi_VC(unit="deg")"angle of VC";
Real i(unit="A")"current";
Real VR(unit="V")"Voltage";
Real VC(unit="V")"Voltage";
Real Irms(unit="A")"rms value of i";
Real VRrms(unit="V")"rms value of VR";
Real VCrms(unit="V")"rms value of VC";
Real P(unit="W")"Power delivered to the circuit";


equation

M_Z=sqrt(Z.re^2+Z.im^2);
phi_Z=atan(Z.im/Z.re)/D2R;
(M_I,phi_I)=PolarOperation(M_E,M_Z,phi_E,phi_Z,1);
(M_VR,phi_VR)=PolarOperation(M_I,M_R,phi_I,phi_R,2);
(M_VC,phi_VC)=PolarOperation(M_I,M_XC,phi_I,phi_XC,2);
i=(Ia+sqrt(2)*M_I*sin((2*t+phi_I)*D2R));

VR=(VRa+sqrt(2)*M_VR*sin((2*t+phi_VR)*D2R));
VC=(VCa+sqrt(2)*M_VC*sin((2*t+phi_VC)*D2R));

Irms=sqrt(Ia^2+M_I^2);
VRrms=sqrt(VRa^2+M_VR^2);
VCrms=sqrt(VCa^2+M_VC^2);

P=(Irms^2)*M_R;

end Ex26_7_a;

function PolarOperation

input Real M1;
input Real M2;
input Real phi1;
input Real phi2;
input Real a;

output Real M;
output Real phi;

algorithm

//division of complex numbers in polar form 
if a==1 then
M:=M1/M2;
phi:=phi1-phi2;
if phi<=-180 then
phi:=phi+180;
end if;

//multiplication of complex number in polar form

elseif a==2 then
M:=M1*M2;
phi:=phi1+phi2;
if phi<=-180 then
phi:=phi+180;
end if;

end if;

end PolarOperation;

end Ex26_7;