model Ex7_3

parameter Real R1(unit="ohm")=4"resistance";
parameter Real R2(unit="ohm")=4"resistance";
parameter Real R3(unit="ohm")=4"resistance";
parameter Real R4(unit="ohm")=0.5"resistance";
parameter Real R5(unit="ohm")=1.5"resistance";
parameter Real E(unit="V")=10"Source Voltage";
parameter Real N=2"Number of resistor";

Real RA(unit="ohm")"resistance";
Real RB(unit="ohm")"resistance";
Real RC(unit="ohm")"resistance";
Real R_BC(unit="ohm")"resistance";
Real RT(unit="ohm")"resistance";
Real Is(unit="A")"source Current";
Real IA(unit="A")"Current";
Real IB(unit="A")"Current";
Real IC(unit="A")"Current";
Real IR2(unit="A")"Current";
Real IR3(unit="A")"Current";
Real VA(unit="V")"Voltage";
Real VB(unit="V")"Voltage";
Real VC(unit="V")"Voltage";

equation

RA=R1;
RB=R2*R3/(R2+R3);
RC=R4+R5;
R_BC=RB/N;
RT=RA+R_BC;
Is=E/RT;
IA=Is;
IB=Is/2;
IC=IB;
IR2=IB/2;
IR3=IR2;
VA=IA*RA;
VB=IB*RB;
VC=VB;



end Ex7_3;