model Ex7_6

parameter Real R1(unit="ohm")=6"resistance";
parameter Real R2(unit="ohm")=6"resistance";
parameter Real R3(unit="ohm")=2"resistance";
parameter Real R4(unit="ohm")=8"resistance";
parameter Real R5(unit="ohm")=12"resistance";
parameter Real E(unit="V")=24"Source Voltage";
parameter Real N=2"Number of resistor";

Real RA(unit="ohm")"resistance";
Real RB(unit="ohm")"resistance";
Real R12(unit="ohm")"resistance";
Real RT(unit="ohm")"resistance";
Real Is(unit="A")"source Current";
Real I2(unit="A")"Current";
Real I4(unit="A")"Current";
Real V1(unit="V")"Voltage";
Real V5(unit="V")"Voltage";

equation

R12=R1/N;
RA=R12*R3/(R12+R3);
RB=R4*R5/(R4+R5);
RT=RA+RB;
Is=E/RT;
I2=V1/R2;
I4=V5/R4;
V1=Is*RA;
V5=Is*RB;

end Ex7_6;