model Ex7_7

parameter Real R1(unit="ohm")=5"resistance";
parameter Real R2(unit="ohm")=3"resistance";
parameter Real R3(unit="ohm")=6"resistance";
parameter Real R4(unit="ohm")=2"resistance";
parameter Real E1(unit="V")=6"Source Voltage";
parameter Real E2(unit="V")=18"Source Voltage";

Real E(unit="V")"Source Voltage";
Real Is(unit="A")"source Current";
Real I1(unit="A")"Current";
Real I3(unit="A")"Current";
Real V1(unit="V")"Voltage";
Real V3(unit="V")"Voltage";
Real Vab(unit="V")"Voltage";

equation

E=E2-E1;
V1=R1*E/(R1+R2);
V3=R3*E/(R3+R4);
V1-V3-Vab=0;
I1=V1/R1;
I3=V3/R3;
Is=I1+I3;

end Ex7_7;