model Ex9_19

parameter Real R1(unit="ohm")=5"Resistance";
parameter Real R2(unit="ohm")=4"Resistance";
parameter Real R3(unit="ohm")=2"Resistance";
parameter Real RL(unit="ohm")=3"Resistance";

parameter Real E1(unit="V")=10"Source Voltage";
parameter Real E2(unit="V")=16"Source Voltage";
parameter Real E3(unit="V")=8"Source Voltage";

Real Req(unit="ohm")"Resistance";
Real Eeq(unit="V")"Source Voltage";
Real IL(unit="A")"Current";
Real VL(unit="V")"Voltage";

equation

Eeq=(E1/R1-E2/R2+E3/R3)/(1/R1+1/R2+1/R3);
Req=1/(1/R1+1/R2+1/R3);
IL=Eeq/(Req+RL);
VL=IL*RL;

end Ex9_19;