model Ex10_6
annotation(experiment(StartTime=0,StopTime=0.5));
parameter Real kd(unit="dm3/mol.h")=9,Cao(unit="mol/dm3")=0.8,tau(unit="h")=0.02,Cto(unit="mol/dm3")=1,k(unit="1/h")=45;
Real a(unit="1",start=1),Ca(unit="mol/dm3",start=.8),X(unit="mol/mol",start=0),yao(unit="1");
equation
der(a)=-kd*a*Ca;
der(Ca)=Cao/tau-((1+yao)/(1+Ca/Cto)+a*tau*k)/tau*Ca;
X=1-(1+yao)/(1+Ca/Cto)*(Ca/Cao);
yao=Cao/Cto;
end Ex10_6;
