model Ex11_2
Real Re(unit="1")"reynolds number",Sc(unit="1")"schimidt number",Sh(unit="1")"sherwood number",kc(unit="m/s"), War(unit="mol/dm2.s");
parameter Real dp(unit="m")=0.01"diameter",U(unit="m/s")=0.1"velocity",v(unit="m2/s")=0.5e-6"kinematic viscosity",Dab(unit="m2/s")=1e-10,Cab(unit="mol/m3")=1e3"bulk concentration",Cas(unit="mol/m3")=0"surface concentration";
equation
Re=dp*U/v;
Sc=v/Dab;
Sh=2+0.6*(Re^0.5)*(Sc^(1/3));
kc=Dab*Sh/dp;
War=kc*(Cab-Cas);
end Ex11_2;
