model Ex13_8
annotation(experiment(StartTime=0,StopTime=200));
Real z(unit="min"),lam(unit="min",start=200),ca(start=8),x(start=0),ra(start=-0.64),E1,E2,F1,F2(start=0.999),E,F;
parameter Real cao(unit="mol/dm3")=8"initial concentration";
parameter Real k(unit="dm3/mol.min")=0.01"rate constant";

equation
der(x)=-(ra/cao+(E/(1-F))*x)*der(z);

lam=12000-z;
z=time;
ca=cao*(1-x);

E1=(4.44658e-10)*(lam^4)-(1.1802e-7)*(lam^3)+(1.35358e-5)*(lam^2)-0.000865652*lam+0.28004;

E2=(-2.64e-9)*(lam^3)+(1.3618e-6)*(lam^2)-0.00024069*lam+0.15011;

F1=(4.44658e-10)/5*(lam^5)-(1.1802e-7)/4*(lam^4)+(1.35358e-5)/3*(lam^3)-0.000865652/2*(lam^2)+0.028004*lam;

F2=-((-9.30769e-8)*(lam^3)+(5.02846e-5)*(lam^2)-0.00941*lam+0.618231-1);

ra=-1*k*ca^2;

if(lam<=70)then
E= E1;
F=F1;
 else
 E=E2;
 F=F2;
 end if;

end Ex13_8;
