package Ex3_6
model Ex3_6a
  import Modelica.SIunits.*;
  Concentration Cao "initial concentration of A";
  Concentration Cae "equilibrium concentration of A";
  Concentration Cbe "equilibrium concentration of B";
  DimensionlessRatio Xe(start = 0) "equilibrium conversion";
  parameter Pressure Po = 202600;
  parameter Real R(unit = "J/mol/K") = 8.314 "universal gas constant";
  parameter Temp_K To = 340;
  parameter MoleFraction yao = 1;
  parameter Real Kc(unit = "mol/m3") = 100;
equation
  Cao = yao * Po / (R * To);
  Cae = Cao * (1 - Xe);
  Cbe = 2 * Cao * Xe;
  Kc = Cbe ^ 2 / Cae;
end Ex3_6a;

model Ex3_6b
//the variation in text book answer and modelica answer is due to rounding off error
  import Modelica.SIunits.*;
  Concentration Cao "initial concentration of A";
  Concentration Cae "equilibrium concentration of A";
  Concentration Cbe "equilibrium concentration of B";
  DimensionlessRatio Xe(start = 0) "equilibrium conversion";
  DimensionlessRatio e=1;
  parameter Pressure Po = 202600;
  parameter Real R(unit = "J/mol/K") = 8.314 "universal gas constant";
  parameter Temp_K To = 340;
  parameter MoleFraction yao = 1;
  parameter Real Kc(unit = "mol/m3") = 100;
equation
  Cao = yao * Po / (R * To);
  Cae = Cao * (1 - Xe)/(1+e*Xe);
  Cbe = 2 * Cao * Xe/(1+e*Xe);
  Kc = Cbe ^ 2 / Cae;
end Ex3_6b;

model Ex3_6c
parameter Real e(unit="1")=1;
parameter Real  Cao(unit="mol/dm3")=0.07174;
parameter Real ka(unit="1/min")=0.5"rate constant";
parameter Real Kc(unit="mol/dm^3")=0.1"equilibirium constant";
Real X"conversion";
Real ra1(unit="mol/dm3.min")"rate of reaction for constant volume process";
Real invra1(unit="dm3.min/mol");
Real invra2(unit="dm3.min/mol");
Real ra2(unit="mol/dm3.min")"rate of reaction for flow process";
equation
ra1=-1*ka*(Cao*(1-X)-4*Cao*Cao*X*X/Kc);
invra1=-1/ra1;
invra2=-1/ra2;
ra2=-1*ka*(Cao*(1-X)/(1+e*X)-4*Cao*Cao*X*X/(Kc*(1+e*X)^2));
X=time;
annotation(experiment(StartTime=0,StopTime=0.5));
//the books answer has a error by the factor of 10

end Ex3_6c;

model Ex3_6d
Real r(unit="mol/dm3*min"),X(unit="1"),V(unit="dm3");
parameter Real F(unit="mol/min")=3;
parameter Real Xe(unit="1")=0.5;
parameter Real Cao(unit ="mol/dm3")=0.072;
parameter Real Kc(unit="mol/dm3")=0.1;
parameter Real ka(unit="1/min")=0.5;
parameter Real e(unit="1")=1;
equation
X=0.8*Xe;
r=-1*ka*((Cao*(1-X))/(1+e*X)-(4*Cao*Cao*X*X/(Kc*(1+e*X)*(1+e*X))));
V=F*X/(-1*r);
//the books answer has a error by the factor of 10
end Ex3_6d;


end Ex3_6;
