package Ex4_2
model Ex4_2a
Real Fc(unit="lb*mol/min")=2*(10^8)/365/24/60/62" molar flow rate of C";
Real X(unit="mol/mol")=0.8"conversion";
Real Caoi( unit="lbmol/ft3")=1"initial concentration of A";
Real k(unit="1/min")=0.311"specific rate constant";
Real vao,vbo,vo"volumetric flow rate of A,B,total";
Real Fao" molar flow rate of A";
Real V(unit="ft3")"volume of cstr ";
equation
Fc=Fao*X;
vao=Fao/Caoi;
vbo=vao;
vo=vbo+vao;
V=vo*X/k/(1-X);
end Ex4_2a;


model Ex4_2b
parameter Real V(unit="ft3")=800/7.48;
Real tou(unit="time")"time constant";
parameter Real k(unit="1/min")=0.311"specific rate constant";
Real X(unit="mol/mol")"conversion";
parameter Real vo(unit="ft3/min")=15.34"volumetric flow rate total";
equation

tou=V/(vo/2);
X=k*tou/(1+k*tou);
end Ex4_2b;


model Ex4_2c
Real tou1(unit="time")"time constant";
parameter Real k(unit="1/min")=0.311"specific rate constant";
parameter Real V(unit="ft3")=800/7.48"volume of each CSTR";
parameter Real vo1(unit="ft3/min")=15.34"initial volumetric flow rate";
Real X2(unit="mol/mol")"conversion for two similar CSTRs in series";
equation
tou1=V/vo1;
X2=1-1/(1+tou1*k)^2;/*equation for equal volume CSTRs in series*/
end Ex4_2c;

end Ex4_2;
