package Ex4_5
//the difference between modelica answer and the textbook answer is due to rounding off error
model Ex4_5a
/* conversion without pressure drop in packed bed*/

import Modelica.SIunit.*;
parameter Real phi(unit="m3/m3")=0.45"void fraction";
parameter Real pc(unit="kg/m3")=1923"solid catalyst density";
parameter Real L(unit="m")=20"length of catalyst";
parameter Real Ac(unit="m2")=0.0013"cross sectional area of catalyst";
parameter Real k(unit="m6/kmol/kgcat/hr")=12"specific reaction rate";
parameter Real Cao(unit="kmol/m3")=0.1"initial concentration of A";
parameter Real vo(unit="m3/hr")=7.15"entering volumetric flow rate";
Real pb(unit="kg/m3")"bulk density of catalyst";
Real W(unit="kg")"weight of the catalyst";
Real X(unit="1")"conversion";
equation
pb=pc*(1-phi);
W=Ac*pb*L;
X=(k*Cao*W/vo)/(1+k*Cao*W/vo);
end Ex4_5a;

model Ex4_5b
/* conversion with pressure drop in packed bed*/
import Modelica.SIunit.*;
parameter Real phi(unit="m3/m3")=0.45"void fraction";
parameter Real pc(unit="kg/m3")=1923"solid catalyst density";
parameter Real L(unit="m")=20"length of catalyst";
parameter Real Ac(unit="m2")=0.0013"cross sectional area of catalyst";
parameter Real k(unit="m6/kmol/kgcat/hr")=12"specific reaction rate";
parameter Real Cao(unit="kmol/m3")=0.1"initial concentration of A";
parameter Real vo(unit="m3/hr")=7.15"entering volumetric flow rate";
parameter Real Bo(unit="kPa/m")=25.8"ergun equation parameter";
parameter Real Po(unit="kPa")=1013"initial pressure";
Real pb(unit="kg/m3")"bulk density of catalyst";
Real W(unit="kg")"weight of the catalyst";
Real X(unit="1")"conversion";
Real a(unit="1/kg")" pressure drop parameter for conversion calculation";
equation
pb=pc*(1-phi);
W=Ac*pb*L;
a=2*Bo/Po/Ac/pb;
X=(k*Cao*W/vo)*(1-a*W/2)/(1+k*Cao*W/vo*(1-a*W/2));
end Ex4_5b;

model Ex4_5c
/* conversion with doubling the catalyst diameter in packed bed*/
import Modelica.SIunit.*;
parameter Real phi(unit="m3/m3")=0.45"void fraction";
parameter Real pc(unit="kg/m3")=1923"solid catalyst density";
parameter Real L(unit="m")=20"length of catalyst";
parameter Real Ac(unit="m2")=0.0013"cross sectional area of catalyst";
parameter Real k(unit="m6/kmol/kgcat/hr")=12"specific reaction rate";
parameter Real Cao(unit="kmol/m3")=0.1"initial concentration of A";
parameter Real vo(unit="m3/hr")=7.15"entering volumetric flow rate";
parameter Real Bo(unit="kPa/m")=25.8"ergun equation parameter";
parameter Real Po(unit="kPa")=1013"initial pressure";
Real pb(unit="kg/m3")"bulk density of catalyst";
Real W(unit="kg")"weight of the catalyst";
Real X(unit="1")"conversion";
Real a(unit="1/kg")" pressure drop parameter for conversion calculation";
equation
pb=pc*(1-phi);
W=Ac*pb*L;
a=2*Bo/2/Po/Ac/pb;
X=(k*Cao*W/vo)*(1-a*W/2)/(1+k*Cao*W/vo*(1-a*W/2));
end Ex4_5c;

end Ex4_5;
