model Ex4_8
parameter Real Po(unit="kPa")=830.6;
parameter Real R(unit="kPa*dm3/mol/K")=8.314;
parameter Real To(unit="K")=500;
Real Cto(unit="mol/dm3")"total initial concentration";
Real Fa(unit="mol/min",start=10)"molar flow rate of A";
Real Fb(unit="mol/min",start=0)"molar flow rate of B";
Real Fc(unit="mol/min",start=0)"molar flow rate of C";
Real Ft(unit="mol/min")"total molar flow rate";
Real ra(unit="mol/dm3/min")"rate of reaction";
Real V(unit="dm3");
parameter Real k(unit="1/min")=0.7" specific rate constant";
parameter Real Kc(unit="mol/dm3")=0.05"equilibirium constant";
parameter Real kc(unit="1/min")=0.2"mass transfer coeff";
equation
Cto=Po/R/To;
Ft=Fa+Fb+Fc;
ra=-1*k*Cto*((Fa/Ft)-Cto/Kc*(Fb/Ft)*(Fc/Ft));
der(Fa)=ra*der(V);
der(Fb)=(-1*ra-kc*Cto*(Fb/Ft))*der(V);
der(Fc)=-1*ra;
V=time;
annotation(experiment(StartTime=0,StopTime=500));
end Ex4_8;
