model Ex6_10
annotation(experiment(StartTime=0,StopTime=10));
Real Fa(unit="mol/min",start=10)"molar flow rate of a";
Real Fb(unit="mol/min",start=10)"molar flow rate of b";
Real Fc(unit="mol/min",start=0)"molar flow rate of c";
Real Fd(unit="mol/min",start=0)"molar flow rate of d";
Real Fe(unit="mol/min",start=0)"molar flow rate of e";
Real Ff(unit="mol/min",start=0)"molar flow rate of f";
Real Ft(unit="mol/min",start=20)"molar flow rate of a";
Real r1a(unit="mol/dm3.min",start=-5)"rate of reaction";
Real r2a(unit="mol/dm3.min",start=-2)"rate of reaction";
Real r4c(unit="mol/dm3.min",start=0)"rate of reaction";
Real r3b(unit="mol/dm3.min",start=0)"rate of reaction";
Real Ca(unit="mol/dm3",start=1)"rate of reaction";
Real ra(unit="mol/dm3.min",start=-7)"rate of reaction";
Real rb(unit="mol/dm3.min",start=-7.75)"rate of reaction";
Real rc(unit="mol/dm3.min",start=5)"rate of reaction";
Real rd(unit="mol/dm3.min",start=10.5)"rate of reaction";
Real re(unit="mol/dm3.min",start=1)"rate of reaction";
Real rf(unit="mol/dm3.min",start=0)"rate of reaction";
Real V(unit="dm3")"volume";
equation
der(Fa)/der(V)=ra;
der(Fb)/der(V)=rb;
der(Fc)/der(V)=rc;
der(Fd)/der(V)=rd;
der(Fe)/der(V)=re;
der(Ff)/der(V)=rf;
V=time;
Ft=Fa+Fb+Fc+Fd+Ff;
r1a=-5*8*(Fa/Ft)*(Fb/Ft)^2;
r2a=-2*4*(Fa/Ft)*(Fb/Ft);
r4c=-5*3.175*(Fc/Ft)*(Fa/Ft)^(2/3);
r3b=-10*8*(Fc/Ft)^2*(Fb/Ft);
Ca=2*Fa/Ft;
ra=r1a+r2a+2*r4c/3;
rb=1.25*r1a+.75*r2a+r3b;
rc=-r1a+2*r3b+r4c;
rd=-1.5*r1a-1.5*r2a-r4c;
re=-.5*r2a-5*r4c/6;
rf=-2*r3b;
end Ex6_10;
