model Ex8_10
annotation(experiment(StartTime=0,StopTime=1));
Real Fa(unit="mol/s",start=100)"molar flow rate of A";
Real Fb(unit="mol/s")"molar flow rate of B";
Real Fc(unit="mol/s")"molar flow rate of C";
Real r1a(unit="mol/dm3.s")"rate of reaction 1";
Real r2a(unit="mol/dm3.s")"rate of reaction of 2";
Real V(unit="dm3")"volume";
Real T(unit="K",start=423)"temperature";
Real k1a(unit="1/s")"rate constant of 1st reaction";
Real k2a(unit="dm3/mol.s")"rate constant of 2nd reaction";
Real Ft(unit="mol/s")"total molar flow rate";
parameter Real Cto(unit="mol/dm3")=0.1;
parameter Real To(unit="K")=423;
Real Ca(unit="mol/dm3")"concentration of A";
Real Cb(unit="mol/dm3")"concentration of B";
Real Cc(unit="mol/dm3")"concentration of C";
equation
der(Fa)=(r1a+r2a)*der(V);
der(Fb)=-1*r1a*der(V);
der(Fc)=-1*r2a/2*der(V);
der(T)=(4000*(373-T)+(-1*r1a)*20000+(-1*r2a)*60000)/(90*Fa+90*Fb+180*Fc)*der(V);
k1a=10*exp(4000*(1/300-1/T));
k2a=0.09*exp(9000*(1/300-1/T));
Ft=Fa+Fb+Fc;
Ca=Cto*(Fa/Ft)*(To/T);
Cb=Cto*(Fb/Ft)*(To/T);
Cc=Cto*(Fc/Ft)*(To/T);
r1a=-1*k1a*Ca;
r2a=-1*k2a*Ca*Ca;
V=time;
end Ex8_10;
