package Ex8_3
model Ex8_3pfr
//solution for pfr
//from the graph the volume comes out to be 2.6m3
//small deviation of the answer from textbook is due to rounding off error
annotation(experiment(StartTime=0,StopTime=0.7));
Real rate(unit="mol/m3.h");

Real Vpfr(unit="m3")"volume of pfr required";

Real k(unit="1/h")"rate constant";

Real rA(unit="mol/m3.h")"rate of reaction";

Real T(unit="K")"temperature ";

parameter Real To(unit="K")=330"temperature of the feed entering";
parameter Real Oi(unit="1")=.1/.9"ratio propane to butane in feed";
parameter Real CpA(unit="J/mol.K")=141"heat capacity of butane";
parameter Real Cpi(unit="J/mol.K")=161"heat capacity of propane";
parameter Real delHRx(unit="J/mol.butane")=-6900"heat of reaction";
parameter Real T1(unit="K")=360"temperature at reaction rate at kT1";
parameter Real kT1(unit="1/h")=31.1"reaction rate at temp T1";
parameter Real E(unit="J/mol.K*h")=65700"Activation energy";
parameter Real R(unit="J/mol.K")=8.314"universal gas constant";
Real Kc(unit="1")"equilibirium constant at temperature T";

parameter Real KcT2(unit="1")=3.03"equilibirium constant at temperature T2";
parameter Real T2(unit="K")=333"given temperature at which equilibirium constant is given";
Real CA(unit="mol/dm3")"concentration of A";
Real CB(unit="mol/dm3")"concentration of B";
parameter Real CAo(unit="kmol/m3")=9.3"initial concentration of A";
parameter Real Fao(unit="kmol/h")=.9*163"molar flow rate of A";

Real X(unit="1")"conversion for the reaction";
equation

T=To+(-1*delHRx)*X/(CpA+Oi*Cpi);
k=kT1*exp(E/R*(1/T1-1/T));
Kc=KcT2*exp(delHRx/R*(1/T2-1/T));
CA=CAo*(1-X);
CB=CAo*X;
rA=-1*k*(CA-CB/Kc);
der(X)=(-1*rA)/Fao*der(Vpfr);
X=time;
rate=-rA;


end Ex8_3pfr;



model Ex8_3cstr
//small deviation from textbook answer is due to rounding off 
Real ratecstr(unit="mol/m3.h")"rate of reaction when cstr is used";
Real Vcstr(unit="m3")"volume of the cstr required";
Real kcstr(unit="1/h")"rate constant for the reaction";
Real rAcstr(unit="mol/m3.h")"negative of rate of reaction";
Real Tcstr(unit="K")"temperature for the reaction";
Real Kccstr(unit="1")"equilibirium constant";
parameter Real Xcstr(unit="1")=.4"conversion for CSTR";
parameter Real delHRx(unit="J/mol.butane")=-6900"heat of formation for the reaction";
parameter Real Fao(unit="kmol/h")=.9*163"molar flow rate ";
parameter Real To(unit="K")=330"temperature at which the feed enters";
parameter Real CpA(unit="J/mol.K")=141"specific heat capacity of butane";
parameter Real Oi(unit="1")=.1/.9"initial ratio of the feed pentane vs butane";
parameter Real Cpi(unit="J/mol.K")=161"specific heat capacity of pentane ";
parameter Real kT1(unit="1/h")=31.1"rate constant at T1";
parameter Real T1(unit="K")=360"temperature";
parameter Real KcT2(unit="1")=3.03"equilibirium constant at T2";
parameter Real R(unit="J/mol.K")=8.314"universal gas constant";
parameter Real T2(unit="K")=333"temperature";
Real CA(unit="mol/dm3")"concentration of A";
parameter Real CAo(unit="kmol/m3")=9.3"initial concentaration of A";
Real CB(unit="mol/dm3")"concentration of B";
parameter Real E(unit="J/mol.K*h")=65700"activation energy for teh reaction";
equation
Vcstr=Fao*Xcstr/((-1)*rAcstr);
Tcstr=To+(-1*delHRx)*Xcstr/(CpA+Oi*Cpi);
kcstr=kT1*exp(E/R*(1/T1-1/Tcstr));
Kccstr=KcT2*exp(delHRx/R*(1/T2-1/Tcstr));
CA=CAo*(1-Xcstr);
CB=CAo*Xcstr;
rAcstr=-1*kcstr*(CA-CB/Kccstr);
ratecstr=-1*rAcstr;
end Ex8_3cstr;



end Ex8_3;
