model Ex8_6
annotation(experiment(StartTime=300,StopTime=600));
Real T(unit="K",start=298);
Real Xe(unit="mol/mol")"conversion by equilibirium constant";
Real Xeb(unit="mol/mol")"conversion by energy balance";
parameter Real Cpa(unit="cal/mol.K")=50"heat capacity of A";
parameter Real Cpb(unit="cal/mol.K")=50"heat capacity of B";
parameter Real delHrx(unit="cal/mol")=-20000"heat of reaction";
parameter Real KeT1(unit="1")=100000"equilibirium constant AT 25 degrees";
Real To(unit="K")=300"temperature ";
Real KeT(unit="1")"equlibirium constant at Temperature T";

equation
Xe=KeT/(1+KeT);
KeT=KeT1*exp(delHrx/1.987*(1/298-1/T));
T=time;
Xeb=-1*Cpa*(T-To)/delHrx;
end Ex8_6;
