model Ex8_8
annotation(experiment(StartTime=535,StopTime=625));
parameter Real vo(unit="ft3/h")=46.62+46.62+233.1"total volumetric flow rate";
parameter Real A(unit="1/h")=16.96e12;
parameter Real E(unit="cal/mol")=32400;
parameter Real R(unit="cal/mol.K")=1.987;
Real T(unit="R");
Real Xmb(unit="mol/mol")"conversion obtained from mole balance";
Real k(unit="1/h")"rate constant";
Real tau(unit="h")" time constant";
parameter Real V(unit="ft3")=40.1"volume";
parameter Real Cpa(unit="Btu/lbmol.F")=35"heat capacity of A";
parameter Real Cpb(unit="Btu/lbmol.F")=18"heat capacity of B";
parameter Real Cpm(unit="Btu/lbmol.F")=19.5"heat capcity of M";
parameter Real Ob(unit="mol/mol")=18.65"ratio";
parameter Real Om(unit="mol/mol")=1.67"ratio";
parameter Real delCp(unit="Btu/lbmol.F")=-7;
parameter Real delHtr(unit="Btu/lbmol")=-36400"heat of formation at standard temperature";
parameter Real Tr(unit="R")=528"reference temperature";
Real Xeb(unit="mol/mol")"conversion from energy balance";
equation
Xmb=k*tau/(1+k*tau);
k=A*exp(-1*E/R/T);
tau=V/vo;
Xeb=-1*(Cpa+Ob*Cpb+Om*Cpm)*(T-535)/(delHtr+delCp*(T-Tr));
T=time;

end Ex8_8;
