model Ex9_1
annotation(experiment(StartTime=0,StopTime=4000));
//data obtained from example 8.8
Real X(unit="mol/mol")"conversion";
Real T(unit="R",start=515)"temperature";
Real k(unit="1/s")"rate constant";
parameter Real To(unit="R")=515;
parameter Real E(unit="Btu/lb.mol.R")=32400"activation energy";
parameter Real ki(unit="1/s")=2.73e-4"rate constant at 535R"; 
Real delHrxo(unit="Btu/lb.mol")"heat of formation at To";
parameter Real delHrxTs(unit="Btu/lb.mol")=-36400"Standard Heat of Reaction";
parameter Real delcp(unit="Btu/lb.mol.R")=-7"obtained from example 8-8f";
parameter Real Tr(unit="R")=535"standard temperature";
Real cps(unit="Btu/lb.mol.F")"Heat of the solution";
parameter Real thetaA(unit="1")=1,cpA(unit="Btu/lb.mol.F")=35,thetaB(unit="1")=18.65,cpB(unit="Btu/lb.mol.F")=18,thetaI(unit="1")=1.670,cpI(unit="Btu/lb.mol.F")=19.5;
equation
der(X)=k*(1-X);
k=ki*exp(E/1.987*(1/Tr-1/T));
T=To-delHrxo/cps*X;
delHrxo=delHrxTs+delcp*(To-Tr);
cps=thetaA*cpA+thetaB*cpB+thetaI*cpI;
end Ex9_1;
