model Ex13_3
Real cai1(unit="kmol/m3")"concentration entering second reactor for 1st case",ca1(unit="kmol/m3")"concentration in the second reactor in case 1",
cai2(unit="kmol/m3")"concentration entering second reactor for 2nd case",ca2(unit="kmol/m3")"concentration in the second reactor in case 2",X1"conversion in 1st case",X2"conversion in second case"; 
parameter Real cao(unit="kmol/m3")=1"initial concentration of the reactant liquid",k(unit="m3/kmol/min")=1"reaction rate constant",ts(unit="min")=1"time constant of cstr",tp(unit="min")=1"time constant of pfr";
equation
//1st case cstr followed by pfr
//cstr mole balance
cao-cai1=k*(cai1^2)*ts;
//pfr mole balance
1/ca1-1/cai1=tp*k;
X1=(cao-ca1)/cao;

//case 2 pfr followed by cstr
1/cai2-1/cao=tp*k;
ts*k*ca2^2+ca2-cai2=0;
X2=(cao-ca2)/cao;
end Ex13_3;
