package Ex2_4
  function cstrvolfunct
    input Real X[7];
    input Real r[7];
    output Real V[4];
  algorithm
    V[1] := 0.4 * X[3] / r[3];
    V[2] := 0.4 * X[4] / r[4];
    V[3] := 0.4 * X[5] / r[5];
    V[4] := 0.4 * X[7] / r[7];
  end cstrvolfunct;

  function funct
    input Real X[7];
    input Real r[7];
    output Real V;
  algorithm
    V := (X[7] - X[1]) / 12 * (0.4 / r[1] + 4 * (0.4 / r[3]) + 2 * (0.4 / r[4]) + 4 * (0.4 / r[5]) + 0.4 / r[7]);
  end funct;

  function funct2
    input Real X[7], r[7];
    output Real v;
  algorithm
    v := (0.6 - 0) / 8 * (0.4 / r[1] + 3 * (0.4 / r[3]) + 3 * (0.4 / r[4]) + 0.4 / r[5]);
  end funct2;

  function funct3
    input Real X[7], r[7];
    output Real v;
  algorithm
    v := (X[4] - X[1]) / 6 * (0.4 / r[1] + 4 * (0.4 / r[3]) + 0.4 / r[4]);
  end funct3;

  function funct4
    input Real X[7], r[7];
    output Real v;
  algorithm
    v := (X[3] - X[1]) / 6 * (0.4 / r[1] + 4 * (0.4 / r[2]) + 0.4 / r[3]);
  end funct4;

  class Ex2_4
    parameter Real Y[7](unit="mol/mol") = {0.0, 0.1, 0.2, 0.4, 0.6, 0.7, 0.8}"conversions";
    parameter Real Z[7](unit="mol/m3.s") = {0.45, 0.37, 0.3, 0.195, 0.113, 0.079, 0.05}"negative of rate for corresponding conversion";
    Real v[4](unit="m3") " volume of pfr array for conversion 0.2,0.4,0.6,0.8";
    Real v_cstr[4](unit="m3") "volume of cstr array for conversion 0.2,0.4,0.6,0.8";
  equation
    v[4] = funct(Y, Z);
    v[3] = funct2(Y, Z);
    v[2] = funct3(Y, Z);
    v[1] = funct4(Y, Z);
    v_cstr = cstrvolfunct(Y, Z);
  end Ex2_4;


end Ex2_4;
