class Ex2_5
  parameter Real X[7](unit="mol/mol")= {0.0, 0.1, 0.2, 0.4, 0.6, 0.7, 0.8} "mole fractions ";
  parameter Real r[7](unit="mol/m3.s") = {0.45, 0.37, 0.3, 0.195, 0.113, 0.079, 0.05} "negative of rates at corresponding molefractions -r";
  Real v1(unit="m3") "volume for X=0.4 conversion";
  Real v2(unit="m3") "volume for x=0.8 conversion";
  Real v(unit="m3") "total volume";
  parameter Real Fa0 (unit="mol/sec")= 0.4 "molar flow rate";
  Real V(unit="m3")"volume for a single reactor for 0.8 conversion";
equation
  v1 = Fa0 * X[4] / r[4];
  v2 = Fa0 * (X[7] - X[4]) / r[7];
  v = v1 + v2;
  V=Fa0/r[7]*X[7];
end Ex2_5;
