class Ex3_5
import Modelica.SIunits.*;
parameter Real P(unit="kPa")=1485;
parameter Real T(unit="K")=500;
parameter Real yao(unit="mol/mol")=0.28 "initial mole fraction of A";
parameter Real R(unit="J/mol*K")=8.314;
Real Ra[4](unit= "mol/m^3/sec")" rate of reaction";
Real Y[4](unit="m^3*sec/mol")"1/Ra[5]";
parameter Real fao(unit="mol/sec")=0.28"percentage of A in total no of moles";
parameter Real fbo(unit="mol/sec")=0.72*0.21"percentage of B in total no of moles";
parameter Real fio(unit="mol/sec")=0.72*0.79"percentage of B in total no of moles";
 Real Ob(unit="mol/sec*sec/mol")"ratio of initial concentration by total initial concentration ";
Real Oi(unit="mol/sec/mol*sec")"ratio of initial concentration by total initial concentration";
DimensionlessRatio  X[5] "conversion";

DimensionlessRatio e  "change in total no of moles for complete conversion per moles fed";
Concentration Ca[5] "concentration of A";
Concentration Cb[5]  "concentration of B";
Concentration Cc[5] "concentration of C";
Concentration Ci[5] "concentration of I";
Concentration Cao "initial concentration of A";
algorithm
X[1]:=0;
Ca[1]:=0.1;
Cb[1]:=0.054;
Cc[1]:=0;
Ci[1]:=0.203;
Ra[1]:=1.08;
Y[1]:=0.926;
Oi:= fio/fao;
Ob:= fbo/fao;
Cao:=yao*P/(R*T);
e:=yao*(1-1-0.5);
for i in 2:5 loop
X[i]:=X[i-1] +0.25;
Ca[i]:=Cao*(1-X[i])/(1+e*X[i]);
Cb[i]:=Cao*(Ob-0.5*X[i])/(1+e*X[i]);
Cc[i]:=Cao*X[i]/(1+e*X[i]);
Ci[i]:=Cao*Oi/(1+e*X[i]);
end for;
for j in 2:4 loop
Ra[j]:=2*(1-X[j])*(Ob-X[j])/(1-e*X[j])^2;
Y[j]:=1/Ra[j];
end for;
end Ex3_5;
