model Ex4_3
Real V(unit="ft3")"volume of the pfr";
parameter Real FB(unit="lb*mol/s")=300e6/365/24/3600/28"molar flow rate of ethylene exiting the reactor";
Real FAo(unit="lb*mol/s");
parameter Real Xf(unit="mol/mol")=0.8"final conversion";
parameter Real k1(unit="1/sec")=0.072"specific reaction rate at Temperature 1000K";
parameter Real T1(unit="K")=1000;
parameter Real T2(unit="K")=1100;
parameter Real To(unit="R")=1980" Temperature in rankine scale";
Real k2 (unit="1/sec")"specific reaction rate at Temperature 1100K";
parameter Real E(unit="cal/g/ mol")=82000"activation energy";
parameter Real C1(unit="cal/g/mol/K")=1.987" universal gas constant";
parameter Real C2(unit="ft3*atm/lb/mol/R")=0.73" universal gas constant";
parameter Real yAo(unit="mol/mol")=1"initial molefraction of A";
parameter Real Po(unit="atm")=6;
Real CAo(unit="mol/ft3")"initial concentration of A";
parameter Real e(unit="1")=1;
equation
FB=FAo* Xf;
k2=k1*exp(E/C1*(1/T1-1/T2));
CAo=yAo*Po/C2/To;
V=FAo/k2/CAo*((1+e)*log(1/(1-Xf))-e*Xf);
end Ex4_3;
