model Ex4_4
/*pressure drop in packed bed*/
parameter Real Po(unit="atm")=10"pressure at z=0 of packed bed";
Real P[7](unit="atm")"pressure drop  in packed bed";
Real delp[7](unit="atm");
Real Bo(unit="lbf/ft3")"ergun equation parameter";
Real z[7](unit="ft");
//parameter Real L(unit="ft")=60"length of packed bed";
Real G(unit="lbm/ft2/hr")"superficial mass velocity";
parameter Real phi(unit="1")=0.45"void fraction";
parameter Real gc(unit="lbm*ft/h2/lbf")=4.17e8;
parameter Real po(unit="lb/ft3")=0.413"initial density of gas";
parameter Real Dp(unit="ft")=0.0208"diameter of particle in bed";
parameter Real v(unit="lb/ft/hr")=0.0673"viscosity of gas";
parameter Real m(unit="lb/hr")=104.4"mass flow rate of gas";
parameter Real Ac(unit="ft2")=0.01414"cross sectional area of packed bed reactor";

algorithm
G:=m/Ac;
Bo:=(G*(1-phi)/(gc*po*Dp*phi^3))*(150*(1-phi)*v/Dp +1.75*G)/144/14.7;
z[1]:=0;
P[1]:=Po;
delp[1]:=0;
for i in 2:7 loop
z[i]:=z[i-1]+10;
P[i]:=Po*(1-2*Bo*z[i]/Po)^0.5;
delp[i]:=Po-P[i];

end for;
end Ex4_4;
