package Ex6_2
//the problem has been divided in two parts
// 1st part calculates for a single CSTR and gets a conversion of 0.72 and second part calculates for CSTR followed by a PFR for conversion greater than 0.72
//small deviation from the answer in text is due to rounding off difference
model Ex6_2_1
// find the maximum selectivity by parametric graph of Sb vs Ca
annotation(experiment(StartTime=0,StopTime=0.5));
Real Sb(unit="1")"selectivity wrt B";
Real Ca(unit= "mol/dm3")"concentration of A";
Real V(unit="dm3")"volume of cstr";
Real Cx(unit="mol/dm3");
Real Cb(unit="mol/dm3");
Real Cy(unit="mol/dm3");
Real X(unit="mol/mol")"conversion for cstr";
parameter Real Cas(unit="mol/dm3")=0.112"concentration of A for maximum selectivity";
parameter Real Cao(unit="mol/dm3")=0.4"initial concentration of A";
parameter Real k1(unit="mol/dm3/s")=0.0001"rate constant for reaction X";
protected parameter Real k2(unit="1/s")=0.0015;
protected parameter Real k3(unit="dm3/mol/s")=0.008;




parameter Real vo(unit="dm3/s")=2"volumetric flow rate";
//from graph while running this program we got Sb_max=0.84 and concentration of A Cas=0.112//
Real ra(unit="mol/dm3/s")"rate of reaction";
equation
Sb=k2*Ca/(k1+k3*Ca^2);
Ca=time;
-1*ra=k1+k2*Cas+k3*Cas^2;
V=vo*(Cao-Cas)/(-1*ra);
Cx=k1*V/vo;
Cb=k2*V/vo*Cas;
Cy=k3*Cas*Cas*V/vo;
X=(Cao-Cas)/Cao;
end Ex6_2_1;






model Ex6_2_2
annotation(experiment(StartTime=0,StopTime=300));
//Cstr followed by pfr for conversion grater than 0.72
Real Ca(unit= "mol/dm3")"concentration of A";
Real V(unit="dm3")"volume of cstr";
Real Cx(unit="mol/dm3");
Real Cb(unit="mol/dm3");
Real Cy(unit="mol/dm3");
Real Sb(unit="1")"selectivity wrt B";

parameter Real Cas(unit="mol/dm3")=0.112"concentration of A for maximum selectivity";
parameter Real Cao(unit="mol/dm3")=0.4"initial concentration of A";
parameter Real k1(unit="mol/dm3/s")=0.0001"rate constant for reaction X";
protected parameter Real k2(unit="1/s")=0.0015;
protected parameter Real k3(unit="dm3/mol/s")=0.008;

parameter Real vo(unit="dm3/s")=2"volumetric flow rate";
//from graph while running Ex6_1_1 we got Sb_max=0.84 and concentration of A Cas=0.112//
Real ra(unit="mol/dm3/s")"rate of reaction";
initial equation

Cx=k1*V/vo;
Cb=k2*V/vo*Cas;
Cy=k3*Cas*Cas*V/vo;
Ca=Cas;
equation
Sb=k2*Ca/(k1+k3*Ca^2);
ra=-1*(k1+k2*Cas+k3*Cas^2);
V=vo*(Cao-Cas)/(-1*ra);
der(Ca)=-1*k1-k2*Ca-k3*Ca^2;
der(Cx)=k1;
der(Cb)=k2*Ca;
der(Cy)=k3*Ca^2;
end Ex6_2_2;



end Ex6_2;
