class Ex7_6
annotation(experiment(StartTime=0,StopTime=43200));
  parameter Real Um(unit="1/s") = 0.33/3600;
  parameter Real Cps(unit="g/dm3") = 93;
  parameter Real m(unit="gsubs/gcell.s") = 0.03/3600;
  parameter Real Ks(unit="g/dm3") = 1.7;
  parameter Real Yps(unit="g/g") = 0.08;
  parameter Real Ypc(unit="g/g") = 5.6;
  parameter Real kd(unit="1/s") = .01/3600;
  parameter Real Ysc(unit="g/g") = 1 / 0.08;
  Real Cc(unit="g/dm3",start = 1);
  Real Cs(unit="g/dm3",start = 250);
  Real Cp(unit="g/dm3");
  Real rg(unit="g/dm3.s");
  Real rd(unit="g/dm3.s");
  Real rsm(unit="g/dm3.s");
  Real kobs(unit="1/s");
equation
  der(Cc) = Um * (1 - Cp / Cps) ^ 0.52 * (Cc * Cs / (Ks + Cs)) - kd * Cc;
  der(Cs) = (-Ysc * Um * (1 - Cp / Cps) ^ 0.52 * (Cc * Cs / (Ks + Cs))) - m * Cc;
  der(Cp) = Ypc * Um * (1 - Cp / Cps) ^ 0.52 * (Cc * Cs / (Ks + Cs));
  rg = Um * (1 - Cp / Cps) ^ 0.52 * Cc * Cs / (Ks + Cs);
  rd = kd * Cc;
  rsm = m * Cc;
  kobs = Um * (1 - Cp / Cps) ^ 0.52;
end Ex7_6;
