model Ex8_2
Real delHTr(unit="kJ/mol N2")"heat of reaction at 298K";
parameter Real HNH3Tr(unit="kcal/mol N2")=-11.020"heat of formation of NH3";
parameter Real CpH2(unit="cal/mol H2")=6.992"heat capacity of H2";
parameter Real CpN2(unit="cal/mol N2")=6.982"heat capacity of N2";
parameter Real CpNH3(unit="cal/mol NH3")=8.92"heat capacity of NH3";
Real delCp(unit ="J/mol N2");
Real delHT(unit="kJ/mol N2")"heat of reaction at 423K";
Real delHTH2(unit="kJ/mol H2")"heat of reaction at 423 per mol of H2 reacted";
equation
delHTr=2*HNH3Tr*4.184;
delCp=(2*CpNH3-3*CpH2-CpN2)*4.184/1000;
delHT=delHTr+delCp*(423-298);
delHTH2=1/3*delHT;

end Ex8_2;
