model Ex8_4
annotation(experiment(StartTime=0,StopTime=5));
parameter Real R(unit="J/mol.K")=8.314"universal gas constant";
parameter Real Cao(unit="mol/dm3")=9.3;
parameter Real Fao(unit="mol/sec")=.9*163*.1/3600;
parameter Real deltaH(unit="kJ/mol")=-6900;
parameter Real Ua(unit="kJ/sec.m3.K")=5000/3600;
parameter Real Ta(unit="K")=310;
parameter Real Cpo(unit="kJ/kmol")=159;
Real X(unit="mol/mol")"conversion";
Real ra(unit="mol/dm3.sec")"rate";
Real T(unit="K",start=310)"temperature";
Real V(unit="dm3")"volume of the reactor";
Real Kc(unit="1")"equilibirium constant";
parameter Real Kc1(unit="1")=3.03"equilibirium constant at temperation 333K";
Real k(unit="1/sec")"rate constant";
parameter Real k1(unit="1/sec")=31.1/3600;
Real Xe(unit="mol/mol")"equilibirium conversion";
Real rate(unit="mol/dm3.sec");
parameter Real E1(unit="J/mol")=65730.484;
parameter Real Ec1(unit="J/mol")=-6903.11;
Real Rate_in_hr(unit="mol/dm3.h");

equation
der(X)=-1*ra/Fao;
der(T)=((ra*deltaH)-Ua*(T-Ta))/Cpo/Fao;
V=time;
Kc=Kc1*exp(Ec1/R*((T-333)/(T*333)));
k=k1*exp(E1/R*(T-360)/(T*360));
Xe=Kc/(1+Kc);
ra=-k*Cao*(1-(1+1/Kc)*X);
rate=-1*ra;
Rate_in_hr=rate*3600;
end Ex8_4;
