model Ex8_9
Real T(unit="R")"temperature";
parameter Real Cpa(unit="Btu/lbmol.F")=35"heat capacity of A";
parameter Real Cpb(unit="Btu/lbmol.F")=18"heat capacity of B";
parameter Real Cpm(unit="Btu/lbmol.F")=19.5"heat capcity of M";
parameter Real Ob(unit="mol/mol")=18.65"ratio";
parameter Real Om(unit="mol/mol")=1.67"ratio";
parameter Real delCp(unit="Btu/lbmol.F")=-7;
parameter Real delHtr(unit="Btu/lbmol")=-36400"heat of formation at standard temperature";
parameter Real Tr(unit="R")=528"reference temperature";
parameter Real Ta(unit="R")=545"cooling temperature";
Real X(unit="mol/mol")"energy balance conversion";
parameter Real U(unit="Btu/h.ft2.F")=100;
parameter Real A(unit="ft2")=40"area of heat exchanger";
parameter Real Fao(unit="lbmol/hr")=43.04"molar flow rate";

equation
//equation from Ex8.8
X=(2.084e12)*exp(-16306/T)/(1+(2.084e12)*exp(-16306/T));
X=-1*((Cpa+Ob*Cpb+Om*Cpm)*(T-535)+U*A*(T-Ta)/Fao)/(delHtr+delCp*(T-Tr));


end Ex8_9;
