package Ex11_3
model Ex11_3a
//the difference between books answer and the answer between code may be due to rounding off error

Real dp(unit="m")"volume average particle diameter",ac(unit="m2/m3")"surface area per volume of bed",Re(unit="1")"reynolds number",Re_dash(unit="1")"mass transfer coeff",gama(unit="1"),Dab(unit="m2/s")"diffusivity at temperature 750",Sc(unit="1")"schimid number",Sh_dash(unit="1")"sherwood number",kc(unit="m/s")"mass transfer coefficient",r(unit="m")"radius",X(unit="mol/mol")"conversion";
parameter Real D(unit="m")=0.0025"diameter",L(unit="m")=0.05"length of the packed bed",Lp(unit="m")=0.005"length of particle",py(unit="1")=0.3"bed porocity",U(unit="m/s")=15"velocity",v(unit="m2/s")=4.5e-4"kinematic viscosity",Dabi(unit="m2/s")=0.69e-4"diffusivity at temperature 298K",Ti(unit="K")=298"temperature at Dabi",T(unit="K")=750"temperature at Dab";
equation
  dp = (6 * D * D * Lp / 4) ^ (1 / 3);
  r=D/2;
  ac = 6 * ((1 - py) / dp);
  Re = dp * U / v;
  gama = (2 * 3.14 * r * Lp + 2 * 3.14 * r * r) / (3.14 * dp * dp);
  Re_dash = Re / (1 - py) / gama;
  Dab = Dabi * (T / Ti) ^ 1.75;
  Sc = v / Dab;
  Sh_dash = (Re_dash ^ 0.5) * Sc ^ (1 / 3);
  kc = Dab * (1 - py) * gama * Sh_dash / dp / py;
  X = 1 - exp(-1 * kc * ac / U * L);
end Ex11_3a;









model Ex11_3b
Real dp(unit="m")"volume average particle diameter",a(unit="m2/m3")"surface area per volume of bed",Re(unit="1")"reynolds number",Dab(unit="m2/s")"diffusivity at temperature 750",Sc(unit="1")"schimid number",Sh(unit="1")"sherwood number",kc(unit="m/s")"mass transfer coefficient",X(unit="mol/mol")"conversion",Jd(unit="1")"colburn Jd factor";
parameter Real D(unit="m")=0.0025"diameter",Lp(unit="m")=0.005"length of the particle",L(unit="m")=0.05"length fo the packed bed",py(unit="1")=0.3"bed porocity",U(unit="m/s")=15"velocity",v(unit="m2/s")=4.5e-4"kinematic viscosity",Dabi(unit="m2/s")=0.69e-4"diffusivity at temperature 298K";
equation
dp=(D*Lp+D*D/2)^0.5;

a= 6 * ((1 - py) / dp);
Re = dp * U / v;
Jd=1/py*((0.765/Re^0.82)+(0.365/Re^0.386));
Dab = Dabi * (750 / 298) ^ 1.75;
 Sc = v / Dab;
Sh=Sc^(1/3)*Re*Jd;
kc=Dab*Sh/dp;
X = 1 - exp(-1 * kc * a / U * L);
end Ex11_3b;




end Ex11_3;
