model Ex12_4
//deviation from text book result is due to rounding off errors//
parameter Real R(unit="m")=3e-3"pellet radius",Dc(unit="m2/s")=1.82e-8"effective diffusivity",pc(unit="g/m3")=2.8e6"density",k1dd(unit="m3/m2.s")=4.42e-10"specific reaction rate",Sa(unit="m2/g")=530"area per gram",v0(unit="m3/s")=1e-6"volumetric velocity",Ac(unit="m2")=2.03e-3"area",dp(unit="m")=6e-3"diameter",phi(unit="1")=0.5"porocity",v(unit="m2/s")=1.53e-8"kinematic viscosity",Dab(unit="m2/s")=2e-8"diffusivity",pb(unit="g/m3")=1.4e6"density",X(unit="1")=0.998"conversion required";
Real phi1(unit="1")"thele modulus",eta(unit="1")"effectiveness factor",U(unit="m/s")"velocity",Red(unit="1")"reynolds number",Sc(unit="1")"schimid number",Shd(unit="1")"sherwood number",kcdd(unit="m/s")"external mass transfer coeff",ac(unit="m2/m3")"external area per unit volume of reactor",omega(unit="1")"overall effectiveness factor",W(unit="g")"weight of solid nessacary for 99.8% conversion",L(unit="m")"length required for 99.8% conversion";
equation
phi1=R*(k1dd*pc*Sa/Dc)^0.5;
eta=3/phi1;//as phi1 is large
U=v0/Ac;
Red=U*dp/(1-phi)/v;
Sc=v/Dab;
Shd=((Red)^0.5)*(Sc)^(1/3);
kcdd=(1-phi)/phi*(Dab/dp)*Shd;
ac=6*(1-phi)/dp;
omega=eta/(1+eta*k1dd*Sa*pb/kcdd/ac);
W=v0/(omega*k1dd*Sa)*log(1/(1-X));
L=W/Ac/pb;

end Ex12_4;
