package Ex2_6
class Ex2_6
  parameter Real Y[7](unit="mol/mol") = {0.0, 0.1, 0.2, 0.4, 0.6, 0.7, 0.8} "mole fractions ";
  parameter Real Z[7](unit="mol/m3.s") = {0.45, 0.37, 0.3, 0.195, 0.113, 0.079, 0.05} "negative of rates at corresponding molefractions -r";
  parameter Real q = 0.4 " molar flow rate in kmol/hr";
  Real v[2](unit="m3") " volume of cstr uptil x=0.2,pfr uptill x=0.6 and cstr uptill x=0.65";
  Real V(unit="m3") "total volume";
equation
  v = funct1(Y, Z, q);
  V = v[1] + v[2];
end Ex2_6;

function funct1
  input Real X[7], r[7], q;
  output Real v[2];
algorithm
  v[1] := (X[4] - X[1]) / 6 * (q / r[1] + 4 * (q / r[3]) + q / r[4]);
  v[2] := (X[7] - X[4]) / 6 * (q / r[4] + 4 * q / r[5] + q / r[7]);
end funct1;
end Ex2_6;
