package Ex2_7
class Ex2_7
  parameter Real X[5](unit="mol/mol") = {0.0,  0.2, 0.4, 0.6, 0.65} " mole fraction of input";
  parameter Real r[5](unit="kmol/m3.h") = {-39,-53,-59,-38,-25} "corresponding rate",fao(unit="kmol/h")=50"entering molar flow rate";
  Real v1(unit="m3")"volume of ist cstr",v2(unit="m3")"volume of pfr in series",v3(unit="m3") "volume of cstr" ;
equation
//for the 1st cstr at X=0.2
v1=fao*X[2]/(-1*r[2]);
  v2 = funct1(X, r,fao);
 v3=fao/(-1*r[5])*(X[5]-X[4]);
end Ex2_7;

function funct1
  input Real X[5], r[5],fao;
  output Real v;
algorithm
  v := (X[2] - X[1]) / 3 * (-1*fao/r[2] +4 * (-1*fao / r[3]) -( fao / r[4]));
  
end funct1;
end Ex2_7;
