model Ex4_6
//according to the parametric plot of X vs W ,for X=60% conversion gives W=45 lbs approximately
//the difference between textbook answer and software answer may be due to difference in the algorithm used for numerical calculations
annotation(experiment(StartTime=0,StopTime=60));
Real f(unit="1")"ratio of volumetric flow rate to entering volumetric flow rate";
parameter Real ma(unit="lb/lbmol")=28,mb(unit="lb/lbmol")=32, mi(unit=
"lb/lbmol")=28"molecular weight of a,b,i respectively";
parameter Real del(unit="1")=1-.5-1"difference between coeff of products and reactants";
parameter Real Fao(unit="lbmol/hr")=1.08"molar flow rate of A";
parameter Real Fbo(unit="lbmol/hr")=0.54"molar flow rate of B";
parameter Real Fi(unit="lbmol/hr")=2.03"molar flow rate of inert I";
Real Fto(unit="lbmol/hr")"total flow rate";
Real yao(unit="mol/mol")"initial mole fraction of A";
Real e(unit="1")"coefficient";
Real mt(unit="lb/hr")"total mass flow rate";
parameter Real Ac(unit="ft2")=0.01414"cross sectional area ";
parameter Real Bo(unit="atm/ft2")=0.0775"parameter of ergun equation";
Real a(unit="1/lb")"parameter";
Real phi(unit="1")=0.45"void fraction";
Real pc(unit="lb/ft3")=120"density of catalyst";
parameter Real Po(unit="atm")=10 "initial pressure";
Real X(unit="1")"conversion";
parameter Real k(unit="lbmol/atm/lbcat/hr")=0.0141"specific rate constant";
Real Pao(unit="atm")"initial partial pressure of A";
Real y(unit="atm/atm",start=1);
Real W(unit="lb",start=0)"weight of catalyst";
Real ra(unit="lbmol/lb.h.cat"),mra"negative of ra";
equation
Fto=Fao+Fbo+Fi;
yao=Fao/Fto;
e=yao*del;
mt=Fao*ma+mb*Fbo+mi*Fi;
a=2*Bo/(Ac*(1-phi)*pc*Po);
Pao=yao*Po;
der(X)=k*Pao*0.63/Fao*(1-X)/(1+e*X)*y*der(W);
y*der(y)+1*a*(1+e*X)/2*der(W)=0;
f=(1+e*X)/y;
W=time;
ra=-1*k*Pao*0.63*(1-X)/(1+e*X)*y;
mra=-ra;
end Ex4_6;
