model Ex4_7
/* gas phase reaction in microreactor*/
Real Cto(unit="mol/dm3")"total concentration";
parameter Real Po(unit="kPa")=1641"initial pressure";
parameter Real R(unit="kPa*dm3/mol/K")=8.314"universal gas constant";
parameter Real T(unit="K")=698;
Real k(unit="dm3/mol/s")"specific rate constant of equation";
Real Fa(unit="mol/sec",start=2.26e-5)"molar flow rate of A";
Real Fb(unit="mol/sec",start=0)"molar flow rate of B";
Real Fc(unit="mol/sec",start=0)"molar flow rate of C";
Real Ft(unit="mol/sec",start=2.26e-5)"total molar flow rate";
Real V(unit="dm3")"volume of B produced per tube final value=1e-5";
Real ra(unit="mol/dm3/sec")"rate of reaction A";
Real rb(unit="mol/dm3/sec")"rate of reaction B";
Real rc(unit="mol/dm3/sec")"rate of reaction c";
equation
k=0.29*exp(24000/1.987*(1/500-1/T));
Cto=Po/R/T;
Ft=Fa+Fb+Fc;
ra=-1*k*Cto^2*(Fa/Ft)^2;
rb=k*Cto^2*(Fa/Ft)^2;
rc=k/2*Cto^2*(Fa/Ft)^2;
der(Fa)=ra*der(V);
der(Fb)=rb*der(V);
der(Fc)=rc*der(V);
V=time;
annotation(experiment(StartTime=0,StopTime=1e-5));
end Ex4_7;
