model Ex4_9
parameter Real Vo(unit="dm3")=5"initial volume";
parameter Real Cao(unit="mol/dm3")=0.05;
parameter Real vo(unit="dm3/s")=0.05"volumetric rate of addition of B";
Real Ca(unit="mol/dm3",start=0.05);
Real Cb(unit="mol/dm3",start=0);
Real Cc(unit="mol/dm3",start=0);
Real Cd(unit="mol/dm3",start=0);
Real V(unit="dm3",start=5)" volume ";
Real X(unit="1")"conversion";
parameter Real k(unit="dm3/s/mol")=2.2"specific rate constant";
parameter Real Cbo(unit="mol/dm3")=0.025;
Real r(unit="mol/dm3/s")"rate";
equation
V=Vo+ vo*time;
der(Ca)=-1*k*Ca*Cb-vo/V*Ca;
der(Cb)=-1*k*Ca*Cb+vo/V*(Cbo-Cb);
der(Cc)=k*Ca*Cb-vo*Cc/V;
der(Cd)=k*Ca*Cb-vo*Cd/V;
X=(Cao*Vo-Ca*V)/(Cao*Vo);
r=k*Ca*Cb;
annotation(experiment(StartTime=0,StopTime=500));
end Ex4_9;
