model Ex6_7
annotation(experiment(StartTime=0,StopTime=0.5));
parameter Real Po(unit="atm")=35;
parameter Real To(unit="R")=1500;
parameter Real R(unit="atm*ft^3/lb mol/R")=0.73;
parameter Real k1(unit="(ft^3/lb mol)^0.5/h")=55.20;
parameter Real k2(unit="(ft^3/lb mol)^0.5/h")=30.20;
parameter Real Cto(unit="lb mol/ft^3")=Po/(R*To)"initial total concentration"; 
Real Ch(unit="lb mol/ft^3");
Real Cm(unit="lb mol/ft^3");
Real Cx(unit="lb mol/ft^3");
parameter Real yh(unit="mol/mol")=0.667;
Real r1h(unit="mol/ft^3/h");
Real r2h(unit="mol/ft^3/h");
Real r1m(unit="mol/ft^3/h");

Real r1x(unit="mol/ft^3/h");
Real r2x(unit="mol/ft^3/h");

initial equation
Ch=yh*Cto;
Cm=0.5*yh*Cto;
Cx=0;
equation
der(Ch)=r1h+r2h;
der(Cm)=r1m;
der(Cx)=r1x+r2x;
r1m=-1*k1*Cm*Ch^.5;

r1h=-1*k1*Cm*Ch^.5;

r1x=k1*Cm*Ch^.5;
r2x=-1*k2*Cx*Ch^.5;
r2h=-1*k2*Cx*Ch^.5;
end Ex6_7;
