model Ex6_8
annotation(experiment(StartTime=0,StopTime=2));
parameter Real Cho(unit="lbmol/ft^3")=0.02"initial concentration of hydrogen";
Real Ch(unit="lbmol/ft^3")"concentration of hydrogen";
parameter Real Cmo(unit="lbmol/ft^3")=.01"initial concentration of mesitylene";
parameter Real k1(unit="(ft^3/lb mol)^0.5/h")=55.20;
parameter Real k2(unit="(ft^3/lb mol)^0.5/h")=30.20;
Real Cm(unit="lbmol/ft^3")"concentration of mesitylene";
Real Cx(unit="lbmol/ft^3")"concentration of xylene";
//For a space time of tau = 0.5, the exiting concentrations are Ch, = 0.0089, Cm = 0.0029. and Cx = 0.003  from the graph//
Real tau(unit="h");
Real Xm(unit="mol/mol")"conversion of mesitylene for tau=0.5";
Real Xh(unit="mol/mol")"conversion of hydrogen for tau=0.5";
Real X1h(unit="mol/mol")"conversion of hydrogen for tau=0.5 in reaction 1";
Real X2h(unit="mol/mol")"conversion of hydrogen for tau=0.5 in reaction 2";
Real Ymx(unit="mol/mol")"yeald mole of xylene produced per mole of mesitylene reacted";
Real Sxt(unit="mol/mol")"selectivity  mole of xylene produced per mole of toulene produced";
equation
Cho-Ch=(k1*(Ch^.5)*Cm+k2*(Ch^.5)*Cx)*tau;
Cmo-Cm=(k1*(Ch^.5)*Cm)*tau;
Cx=(k1*(Ch^.5)*Cm-k2*(Ch^.5)*Cx)*tau;
tau=time;
Xm=(0.0105-0.0029)/0.0105;//(Cmo-Cm)/Cmo
Xh=(0.021-0.0089)/0.021;//Cho-Ch/Cho
X1h=(0.0105-0.0029)/0.021;//(Cmo-Cm)/Cho
X2h=Xh-X1h;
Ymx=0.00313/(0.0105-.0029);//Cx/(Cmo-Cm)
Sxt=.00313/(0.0105-.0029-.00313);//Cx/(Cmo-Cm-Cx)

end Ex6_8;
